import {
  createMigrationIds,
  createRecordMigrationSequence,
  createRecordType
} from "@tldraw/store";
import { T } from "@tldraw/validate";
import { boxModelValidator } from "../misc/geometry-types.mjs";
import { idValidator } from "../misc/id-validator.mjs";
import { cursorTypeValidator } from "../misc/TLCursor.mjs";
import { scribbleValidator } from "../misc/TLScribble.mjs";
const instancePresenceValidator = T.model(
  "instance_presence",
  T.object({
    typeName: T.literal("instance_presence"),
    id: idValidator("instance_presence"),
    userId: T.string,
    userName: T.string,
    lastActivityTimestamp: T.number,
    followingUserId: T.string.nullable(),
    cursor: T.object({
      x: T.number,
      y: T.number,
      type: cursorTypeValidator,
      rotation: T.number
    }),
    color: T.string,
    camera: T.object({
      x: T.number,
      y: T.number,
      z: T.number
    }),
    screenBounds: boxModelValidator,
    selectedShapeIds: T.arrayOf(idValidator("shape")),
    currentPageId: idValidator("page"),
    brush: boxModelValidator.nullable(),
    scribbles: T.arrayOf(scribbleValidator),
    chatMessage: T.string,
    meta: T.jsonValue
  })
);
const instancePresenceVersions = createMigrationIds("com.tldraw.instance_presence", {
  AddScribbleDelay: 1,
  RemoveInstanceId: 2,
  AddChatMessage: 3,
  AddMeta: 4,
  RenameSelectedShapeIds: 5
});
const instancePresenceMigrations = createRecordMigrationSequence({
  sequenceId: "com.tldraw.instance_presence",
  recordType: "instance_presence",
  sequence: [
    {
      id: instancePresenceVersions.AddScribbleDelay,
      up: (instance) => {
        if (instance.scribble !== null) {
          instance.scribble.delay = 0;
        }
      }
    },
    {
      id: instancePresenceVersions.RemoveInstanceId,
      up: (instance) => {
        delete instance.instanceId;
      }
    },
    {
      id: instancePresenceVersions.AddChatMessage,
      up: (instance) => {
        instance.chatMessage = "";
      }
    },
    {
      id: instancePresenceVersions.AddMeta,
      up: (record) => {
        record.meta = {};
      }
    },
    {
      id: instancePresenceVersions.RenameSelectedShapeIds,
      up: (_record) => {
      }
    }
  ]
});
const InstancePresenceRecordType = createRecordType(
  "instance_presence",
  {
    validator: instancePresenceValidator,
    scope: "presence"
  }
).withDefaultProperties(() => ({
  lastActivityTimestamp: 0,
  followingUserId: null,
  color: "#FF0000",
  camera: {
    x: 0,
    y: 0,
    z: 1
  },
  cursor: {
    x: 0,
    y: 0,
    type: "default",
    rotation: 0
  },
  screenBounds: {
    x: 0,
    y: 0,
    w: 1,
    h: 1
  },
  selectedShapeIds: [],
  brush: null,
  scribbles: [],
  chatMessage: "",
  meta: {}
}));
export {
  InstancePresenceRecordType,
  instancePresenceMigrations,
  instancePresenceValidator,
  instancePresenceVersions
};
//# sourceMappingURL=TLPresence.mjs.map
